/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.modules.visuals;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.game.PostAttackEvent;
import Krasnodar.rockstarnew.systems.event.impl.render.Render3DEvent;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.systems.setting.settings.BooleanSetting;
import Krasnodar.rockstarnew.systems.setting.settings.ColorSetting;
import Krasnodar.rockstarnew.systems.setting.settings.SliderSetting;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import Krasnodar.rockstarnew.utility.colors.Colors;
import Krasnodar.rockstarnew.utility.interfaces.IMinecraft;
import Krasnodar.rockstarnew.utility.render.Draw3DUtility;
import Krasnodar.rockstarnew.utility.render.DrawUtility;
import Krasnodar.rockstarnew.utility.render.RenderUtility;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_9801;

@ModuleInfo(name="HitEffect", category=ModuleCategory.VISUALS, desc="\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u0432\u043e\u043b\u043d\u043e\u0432\u043e\u0439 \u044d\u0444\u0444\u0435\u043a\u0442 \u043f\u0440\u0438 \u0443\u0434\u0430\u0440\u0435 \u043f\u043e \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438")
public class HitEffect
extends BaseModule {
    private final SliderSetting particleCount = new SliderSetting(this, "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0447\u0430\u0441\u0442\u0438\u0446").min(10.0f).max(50.0f).step(1.0f).currentValue(20.0f);
    private final SliderSetting particleSize = new SliderSetting(this, "\u0420\u0430\u0437\u043c\u0435\u0440 \u0447\u0430\u0441\u0442\u0438\u0446").min(0.1f).max(1.0f).step(0.05f).currentValue(0.3f);
    private final SliderSetting spreadDistance = new SliderSetting(this, "\u0414\u0438\u0441\u0442\u0430\u043d\u0446\u0438\u044f \u0440\u0430\u0437\u043b\u0451\u0442\u0430").min(0.5f).max(3.0f).step(0.1f).currentValue(1.5f);
    private final SliderSetting lifetime = new SliderSetting(this, "\u0412\u0440\u0435\u043c\u044f \u0436\u0438\u0437\u043d\u0438").min(0.5f).max(3.0f).step(0.1f).currentValue(1.5f);
    private final SliderSetting smoothness = new SliderSetting(this, "\u041f\u043b\u0430\u0432\u043d\u043e\u0441\u0442\u044c").min(0.1f).max(1.0f).step(0.05f).currentValue(0.5f);
    private final BooleanSetting bouncePhysics = new BooleanSetting(this, "\u0424\u0438\u0437\u0438\u043a\u0430 \u043e\u0442\u0441\u043a\u043e\u043a\u0430").enabled(true);
    private final ColorSetting color = new ColorSetting(this, "\u0426\u0432\u0435\u0442").color(Colors.ACCENT);
    private final BooleanSetting rainbow = new BooleanSetting(this, "\u0420\u0430\u0434\u0443\u0436\u043d\u044b\u0439").enabled(false);
    private final List<WaveEffect> waveEffects = new ArrayList<WaveEffect>();
    private final List<HitParticle> particles = new ArrayList<HitParticle>();
    private final Random random = new Random();
    private final EventListener<PostAttackEvent> onAttack = event -> {
        class_1297 target = event.getEntity();
        if (target == null) {
            return;
        }
        class_243 pos = target.method_19538();
        class_2338 basePos = class_2338.method_49637((double)pos.field_1352, (double)(pos.field_1351 - 0.1), (double)pos.field_1350);
        this.addWave(basePos);
        this.spawnHitParticles(target.method_19538().method_1031(0.0, (double)(target.method_17682() / 2.0f), 0.0));
    };
    private final EventListener<Render3DEvent> onRender3D = event -> {
        if (HitEffect.mc.field_1687 == null) {
            return;
        }
        if (!this.waveEffects.isEmpty()) {
            Iterator<WaveEffect> iterator = this.waveEffects.iterator();
            while (iterator.hasNext()) {
                WaveEffect wave = iterator.next();
                if (wave.isExpired()) {
                    iterator.remove();
                    continue;
                }
                wave.render((Render3DEvent)event);
            }
        }
        if (!this.particles.isEmpty()) {
            class_4587 ms = event.getMatrices();
            class_4184 camera = HitEffect.mc.field_1773.method_19418();
            ms.method_22903();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
            RenderSystem.enableDepthTest();
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)false);
            class_2960 bloomTexture = Rockstar.id("textures/bloom.png");
            RenderSystem.setShaderTexture((int)0, (class_2960)bloomTexture);
            RenderSystem.setShader((class_10156)class_10142.field_53880);
            class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            Iterator<HitParticle> particleIterator = this.particles.iterator();
            while (particleIterator.hasNext()) {
                HitParticle particle = particleIterator.next();
                if (particle.isExpired()) {
                    particleIterator.remove();
                    continue;
                }
                particle.update();
                particle.render(builder, ms, camera);
            }
            class_9801 builtBuffer = builder.method_60794();
            if (builtBuffer != null) {
                class_286.method_43433((class_9801)builtBuffer);
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderTexture((int)0, (int)0);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.disableDepthTest();
            ms.method_22909();
        }
    };

    private void spawnHitParticles(class_243 hitPos) {
        int count = (int)this.particleCount.getCurrentValue();
        float spread = this.spreadDistance.getCurrentValue();
        for (int i = 0; i < count; ++i) {
            double theta = this.random.nextDouble() * 2.0 * Math.PI;
            double phi = this.random.nextDouble() * Math.PI;
            double x = Math.sin(phi) * Math.cos(theta);
            double y = Math.sin(phi) * Math.sin(theta);
            double z = Math.cos(phi);
            double speed = 0.15 * (double)spread + this.random.nextDouble() * 0.1 * (double)spread;
            class_243 velocity = new class_243(x * speed, y * speed, z * speed);
            this.particles.add(new HitParticle(hitPos, velocity, (long)(this.lifetime.getCurrentValue() * 1000.0f)));
        }
    }

    private void addWave(class_2338 pos) {
        if (HitEffect.mc.field_1687 != null) {
            this.waveEffects.add(new WaveEffect(pos, System.currentTimeMillis()));
        }
    }

    @Override
    public void onEnable() {
        super.onEnable();
        this.particles.clear();
        this.waveEffects.clear();
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.particles.clear();
        this.waveEffects.clear();
    }

    private class HitParticle {
        private class_243 position;
        private class_243 velocity;
        private final long startTime;
        private final long lifetime;
        private final float size;
        private final float rotationSpeed;
        private float rotation;
        private static final double BOUNCE_DAMPING = 0.6;
        private static final double GROUND_THRESHOLD = 0.1;

        public HitParticle(class_243 position, class_243 velocity, long lifetime) {
            this.position = position;
            this.velocity = velocity;
            this.startTime = System.currentTimeMillis();
            this.lifetime = lifetime;
            this.size = HitEffect.this.particleSize.getCurrentValue();
            this.rotation = HitEffect.this.random.nextFloat() * 360.0f;
            this.rotationSpeed = (HitEffect.this.random.nextFloat() - 0.5f) * 5.0f;
        }

        public void update() {
            double maxY;
            class_265 shape;
            class_2338 blockPos;
            class_2680 blockState;
            float smoothFactor = HitEffect.this.smoothness.getCurrentValue();
            this.position = this.position.method_1019(this.velocity);
            this.velocity = this.velocity.method_1021(0.95 * (double)smoothFactor + 0.05);
            this.velocity = this.velocity.method_1031(0.0, -0.01 * (double)smoothFactor, 0.0);
            if (HitEffect.this.bouncePhysics.isEnabled() && IMinecraft.mc.field_1687 != null && !(blockState = IMinecraft.mc.field_1687.method_8320(blockPos = class_2338.method_49637((double)this.position.field_1352, (double)(this.position.field_1351 - 0.1), (double)this.position.field_1350))).method_26215() && this.velocity.field_1351 < 0.0 && !(shape = blockState.method_26218((class_1922)IMinecraft.mc.field_1687, blockPos)).method_1110() && this.position.field_1351 <= (maxY = shape.method_1107().field_1325 + (double)blockPos.method_10264()) + 0.1) {
                this.position = new class_243(this.position.field_1352, maxY + 0.01, this.position.field_1350);
                this.velocity = new class_243(this.velocity.field_1352, -this.velocity.field_1351 * 0.6, this.velocity.field_1350);
                if (Math.abs(this.velocity.field_1351) < 0.02) {
                    this.velocity = new class_243(this.velocity.field_1352 * 0.8, 0.0, this.velocity.field_1350 * 0.8);
                }
            }
            this.rotation += this.rotationSpeed * smoothFactor;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.startTime > this.lifetime;
        }

        public void render(class_287 builder, class_4587 ms, class_4184 camera) {
            ColorRGBA particleColor;
            long elapsed = System.currentTimeMillis() - this.startTime;
            float progress = (float)elapsed / (float)this.lifetime;
            float alpha = (float)Math.pow(1.0f - progress, 2.0);
            float scale = this.size * (1.0f + (float)Math.sin((double)progress * Math.PI) * 0.2f);
            ms.method_22903();
            RenderUtility.prepareMatrices(ms, this.position);
            ms.method_22907(camera.method_23767());
            ms.method_22907(class_7833.field_40718.rotationDegrees(this.rotation));
            if (HitEffect.this.rainbow.isEnabled()) {
                float hue = (float)(System.currentTimeMillis() % 3000L) / 3000.0f;
                particleColor = ColorRGBA.fromHSB(hue, 1.0f, 1.0f).withAlpha(alpha * 255.0f);
            } else {
                particleColor = HitEffect.this.color.getColor().withAlpha(alpha * 255.0f);
            }
            DrawUtility.drawImage(ms, builder, (double)(-scale) / 2.0, (double)(-scale) / 2.0, 0.0, (double)scale, (double)scale, particleColor);
            ms.method_22909();
        }
    }

    private class WaveEffect {
        private final class_2338 centerPos;
        private final long startTime;
        private final long duration = 1500L;
        private final int maxRadius = 12;

        public WaveEffect(class_2338 centerPos, long startTime) {
            this.centerPos = centerPos;
            this.startTime = startTime;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.startTime > 1500L;
        }

        public void render(Render3DEvent event) {
            ColorRGBA clientColor;
            if (IMinecraft.mc.field_1687 == null) {
                return;
            }
            long elapsed = System.currentTimeMillis() - this.startTime;
            float progress = (float)elapsed / 1500.0f;
            float currentRadius = progress * 12.0f;
            float waveWidth = 2.5f;
            float globalAlpha = (float)Math.pow(1.0f - progress, 0.6);
            int rendered = 0;
            int foundBlocks = 0;
            int maxPerFrame = 400;
            float minRadSq = (currentRadius - waveWidth) * (currentRadius - waveWidth);
            float maxRadSq = (currentRadius + 0.5f) * (currentRadius + 0.5f);
            if (HitEffect.this.rainbow.isEnabled()) {
                float hue = (float)(System.currentTimeMillis() % 3000L) / 3000.0f;
                clientColor = ColorRGBA.fromHSB(hue, 1.0f, 1.0f);
            } else {
                clientColor = HitEffect.this.color.getColor();
            }
            RenderUtility.setupRender3D(true);
            RenderSystem.lineWidth((float)1.0f);
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_29344, class_290.field_1576);
            for (int x = -12; x <= 12; ++x) {
                for (int z = -12; z <= 12; ++z) {
                    class_2338 checkPos;
                    class_2338 renderPos;
                    if (rendered >= maxPerFrame) {
                        RenderUtility.buildBuffer(builder);
                        RenderUtility.endRender3D();
                        return;
                    }
                    float distSq = x * x + z * z;
                    if (distSq < minRadSq || distSq > maxRadSq || (renderPos = this.findSurface(checkPos = this.centerPos.method_10069(x, 0, z))) == null) continue;
                    ++foundBlocks;
                    class_2680 state = IMinecraft.mc.field_1687.method_8320(renderPos);
                    class_265 shape = state.method_26218((class_1922)IMinecraft.mc.field_1687, renderPos);
                    if (shape.method_1110()) continue;
                    ++rendered;
                    float distance = (float)Math.sqrt(distSq);
                    float localAlpha = 1.0f - Math.abs(distance - currentRadius) / waveWidth;
                    if (!((localAlpha = Math.max(0.0f, Math.min(1.0f, localAlpha)) * globalAlpha) > 0.05f)) continue;
                    ColorRGBA color = clientColor.withAlpha(localAlpha * 255.0f);
                    try {
                        class_238 box = shape.method_1107().method_996(renderPos);
                        Draw3DUtility.renderOutlinedBox(event.getMatrices(), builder, box, color);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (progress < 0.1f && foundBlocks == 0) {
                System.out.println("[HitEffect] WARNING: No blocks found! Center: " + String.valueOf(this.centerPos));
            }
            RenderUtility.buildBuffer(builder);
            RenderUtility.endRender3D();
        }

        private class_2338 findSurface(class_2338 pos) {
            for (int y = 2; y >= -4; --y) {
                class_2338 p = pos.method_10086(y);
                if (IMinecraft.mc.field_1687.method_8320(p).method_26215() || !IMinecraft.mc.field_1687.method_8320(p.method_10084()).method_26215()) continue;
                return p;
            }
            return null;
        }
    }
}

